; ==================================================================
; (c) .,  2009-2012, 2025
;    (6 )
; ==================================================================
;   :
; 
;
;              

;     :
; 1-:  main   SDCard_Run (       )
; 2-:  512  synth_procedure (    ),  .   - Column_0_Int (  )
;              . 1   1/128  .
;
;
;
;
;     -   24  :12 :8 = 250 ,
;     2  4  PRS8,  8 -  Counter8_99   16 -  VC3.
;   "" A4 (250  :4:142) = 440,141  ( 440 ).
;
; <-----------------T  ----------------->  <--T:2--> 
;    :16   :16   :16   :8    :4    :2     :1         :1
;  C0... C1... C2... C3... C4... C5...   C6..B6     C7..B7
; <---->  <-------------6  --------------->
;
;       SD   (  ptrR  ptrW).
;      (     ).
;        -       set_track::    start::
;         -  .
; !!!   5 ( )   SD,     SD
; !!!    ()    PLL (   Synth.asm)


; ==================================================================
;      :
; ==================================================================
;17 -   3
;18 -      
;19 -     ("" - "." - "." - "")
;   -    PLL (   )
;   - CPU 12   (    3 )
;   -    .
;   -        0 - !
;20 -   COM 
;21 - :  ,  32 
;22 - :  ,  32 ,      ,    440
;23 -    512       ( synth.asm).    .
;24 -     ( . );       
;   - !.   2-   (    1),  .
;   - !  PWM     synth_notes_off.
;   - !synth_notes_off    (   ).
;25 -     24 (  )
;26 -         (   BLDC )
;   -  "  PWM     synth_notes_off"  , .. .
;   -  .    2-   (   ).
;26-2 -  3.25 /   -  synth_procedure/
;===================================================================
;28-1 -   SD, MMC, SDHC (FAT16,      ).   .
;28-2 -    (   -   FLASH).   .     .     .
;28-3 -   -  .      ("MUZDATA"). -     "  "  "  ".   
;     -  
;     - ,           
;     -        Play (    ) 
;28-4 -   -      CS    (    )
;     -     -    (    )
;     -        LVD_ISR:: -   CS      (  startupcnt    !)
;     -  c MMC    -     3  " muzdata  " 
;28-5 -   c MMC    -   .    Data_LBA (..     )
;28-6 -       
;     -     track4.inc (   000)
;28-7 -    UART  "RX8_1".     . -.
;     -     1    1  
;28-8 -    : VC2   125  250 ,
;     - Counter8_99   :8,  VC3   :16,         2 (     :2  :4)
;             1           
;29-1 -    Sdcard.asm v2.14 (   ).
;        :        SDCard_Callback_Procedure,
;                           ( SDCard_ReadDataBuff),  : ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                                                      
;                                                                                            ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;     -     ptrR  ptrW ()   Sdcard.asm  Synth.asm (  )
;29-2 -  Port 1_5 ... 1_7,  SD  -  .       (      )
;29-3 -        ( synth.asm).
;         0x0E 0xXX (" ")     .  120 bpm  2- ,  0x87.
;     -    c     (3 ) -   .    Data_LBA (..     ).
;       (  Sdcard.asm v2.14    )
;29-4 -    PLL,   FLASH  ,  .
;     -    synth_init:: -    120 bpm    mov [tempo],16
;     -     0,5*  0,042*Ucc (0.14 )
;     -  [cntT]  6  8,     = "1/2 " = 1    120 bpm (    -       )
;     -         (.)
;30-1 -  [cntT]   8 ( =6,      1.1/3  )
;     -    7   ,    (..  6  -    0)
;     -      ( LVD_ISR) -         
;     -   LVD_ISR -     VLT_CMP  OSC_CR0    1 
;                             -         
;                             -     (     ) 
;                             -        (   )
;                             -   
;     -         ( )
;30-2 -  Synth.asm           
;30-3 -  
;30-4 - 10   
;     -    SDCard.asm   2        FF  



;             PLL ! (  jmp .n3  synth_procedure:: )

;TODO:
;1. ----  
;2. ----    2 -   Rx8,     Counter8   VC3=VC2/16
;3. ----            
;4.    DC-DC - ,    !


include "m8c.inc"
include "PSoCAPI.inc"
include "Synth.inc"	; CMAX
include "SDCard.inc"


export _main
_main:

	;    (ECO)       PLL (  synth.asm)
;    or reg[CPU_SCR1],CPU_SCR1_ECO_ALLOWED	;   --     boot.tpl
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	M8C_SetBank1
	;or reg[OSC_CR0],0x80	;  ,      1  -   , ..   synth.asm
							;(  ILO  ECO        )
	mov reg[ECO_TR],0x47	;   ,  "B"  ("0x77" =   "B"   )
	M8C_SetBank0
	mov [startupcnt+0],1	;   -  512+1     . (1   )
	mov [startupcnt+1],0x02	;        1  (     )
	;   synth.asm   ,     PLL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


	;    2  
	;    "Equal To"     :
	mov reg[PRS8_1_POLY_REG],0b00001000	;Polynomial Register
	mov reg[PRS8_1_SEED_REG],0b00000001	;Shift=Seed Register 
	call PRS8_1_Start
	;    :2  :4  OutputBitStream  CompareOut  PRS8
	;    OR ( XOR) --  Clk:2 

	;  ,  SD ,    (          ) -    CS=1  
	or reg[PRT1DR], (SDCard_CS_Mask|SDCard_CLK_Mask|SDCard_DI_Mask)	;111xxxxx ( ,     SD)
	
	; Port 0_0 ... 0_5      
	or  reg[PRT0GS],0b00111111 //lines 0..5 are connected to Global Bus. 
	//STRONG DRIVE 
    M8C_SetBank1
	and reg[PRT0DM2],~0b00111111
	or  reg[PRT0DM0], 0b00111111 
	and reg[PRT0DM1],~0b00111111
    ;    Port 1_5 ... 1_7   (  SD ).   .   .  !
	//SLOW STRONG DRIVE 
	or  reg[PRT1DM2], (SDCard_CS_Mask|SDCard_CLK_Mask|SDCard_DI_Mask)
	or  reg[PRT1DM0], (SDCard_CS_Mask|SDCard_CLK_Mask|SDCard_DI_Mask)
	and reg[PRT1DM1],~(SDCard_CS_Mask|SDCard_CLK_Mask|SDCard_DI_Mask)
    M8C_SetBank0


	; ( )  
	mov A, 1
	call CMPPRG_1_Start
	;mov A, RX8_1_PARITY_NONE
	;call RX8_1_Start		;UART 9600,8,N,1 (   COM)
	;call RX8_1_EnableInt	;  -    .   .   rx8_1int.asm
	call Counter8_1_Start
	call Counter8_2_Start
	call Counter8_3_Start
	call Counter8_4_Start
	call Counter8_5_Start
	call Counter8_6_Start
	call Counter8_99_Start	;.  8

	;    
	mov [mask],0x08	; 
	mov [keys+0],0
	mov [keys+1],0
	mov [keycnt],0
	mov [mode],0	;       
	
	;    
	or reg[INT_MSK0],0x40
	;   Column 0
	or reg[INT_MSK0],0x02
	;     (LVD)
	or reg[INT_MSK0], 0x01
	
	;    (  VLT_CMP)
	call WaitLVD				;    (  VLT_CMP).     .

	;2-  -     LVD_ISR -     (  VLT_CMP)
	;or reg[INT_MSK3],0x80		;  -  1   INT_CLRx    
	;or reg[INT_CLR0],0x01		;    
	;and reg[INT_MSK3],~0x80	;  -  0   INT_CLRx    ( )

	;   
	M8C_EnableGInt



;------------------------      -----------------------------

set_track::
	;   
	wait:	cmp [keycnt],CMAX	;      (      - CMAX -)
			jc wait
	;  3        
	mov A,[keys+1]	;1- 
	and A,0x0F
	or  A,'0'
	mov [altName+0],A
	mov A,[keys+0]	;2- 
	asr A
	asr A
	asr A
	asr A
	and A,0x0F
	or  A,'0'
	mov [altName+1],A
	mov A,[keys+0]	;3- 
	and A,0x0F
	or  A,'0'
	mov [altName+2],A

;------------------------  ,   ---------------------------
start::
	;  
	mov A,__ramareas_end	;Set top of stack to end of used RAM
	swap SP,A
	;   ,   
	call synth_init
	call synth_notes_off

	;   
	M8C_EnableGInt
	;  .   synth.asm
	;  .   rx8_1int.asm

	;jmp playFLASH

;--------------------------    SD ----------------------------------
	mov [ClstN],10		; 10 .  [ClstN]    (   ,    )

try_again:
	call SDCard_Run		;     ,    .
						; -   ,  . .
	cmp A,0				; 
	jz wait_finish		;  -     
	;toLCD_String 0,0,"NOT OK!     "
	;mov [etap],0x0	;
	;--------------------------   -----------------------------------
	;	[etap]	=0x*0 - ,  4  -  :
;						0x00 -   
;						0x10 - SD  2   (v1.0)
;						0x20 - MMC  2  (v1.0)
;						0x30 - SD  2   (v2.0)
;						0x40 - SDHC ( 2 ) v2.0
;			=0x01 -      SPI ( )
;			=0x02 -     SPI,   V1.0 (SD/MMC),    
;			=0x03 -     SPI,   V2.0 (SD/SDHC),    
;			=0x04 -     SPI,   V2.0,     SD-SDHC 
;			=0x*5 -   ,      (  0- ,    )  ( 4  -  )
;			=0x*6 -  FAT16 - 0   
;			=0x*7 -  FAT16 -  2  FAT
;			=0x*8 -  FAT16 -   "FAT16"
;			=0x*9 -    
;			=0x*A -   
;			=0x*B -        FAT
;			=0x*C -
;			=0x*D -
;			=0x*E -
;			=0x*F -   ,  "FAT16" ,      "  " (,  )  
	mov A,[etap]	;    4 
	and A,0xF
	sub A,2
	jnc .get_beep_n			;   >= 0x02 (" ") -    
			;   < 0x02 (" ") -    
			dec [ClstN]		; 
			jnz try_again	;    - 		
			jmp playFLASH	;   < 0x02 (" ")  -     FLASH.
	
.get_beep_n:
	;  X  :
		;1   -  ,     									(0x*2, 0x*3, 0x*4)
		;2   -    FAT16										(0x*6, 0x*7, 0x*8, 0x*B)
		;3   -   "MUZDATA"												(0x*9) 
		;4   -     										(0x*A) 
		;5  -      (  0-   )	(0x*5, 0x*F) 
	index beeps				;  A    
	jz .noBeeps				; 0,    
	mov X,A					;  X  

.beep:	
	;  ( X -   1...5)

	;  -  1-  
	push X
	call synth_notes_off				;       (     array  0)
	pop X
	Counter8_1_Stop_M
	M8C_DisableGInt
	mov reg[Counter8_1_PERIOD_REG],125	;  1-  ( 1000 )
	mov reg[Counter8_1_COMPARE_REG],40	;  ( )
	M8C_SetBank1
	mov reg[Counter8_1_INPUT_REG],0x16	;  Clk = VC2 (24  :12:16 = 125 )    
	M8C_SetBank0
	mov [array+0+2],40					; -          (    synth_procedure) 
	Counter8_1_Start_M
	M8C_EnableGInt
	
	; 0,5 
	mov [startupcnt+0],154				;254  .   - "" .   PLL,     	
	.wait01:
		;mov [tickcnt],0					; -     (      -      Play) 
		cmp [startupcnt+0],255			;    synth_procedure   512 
		jc .wait01

	; 		
	mov reg[Counter8_1_COMPARE_REG],0
	mov [array+0+2],0					; -          (    synth_procedure) 

	; 0,5 
	mov [startupcnt+0],154				;254  .   - "" .   PLL,     	
	.wait02:
		;mov [tickcnt],0					; -     (      -      Play) 
		cmp [startupcnt+0],255			;    synth_procedure   512 
		jc .wait02
	dec X
	jnz .beep							; X - 

.noBeeps:
	;   -     
	jmp wait_loop

.LITERAL
beeps:			;       
;   0x02 0x03 0x04 0x05 0x06 0x07 0x08 0x09 0x0A 0x0B 0x0C 0x0D 0x0E 0x0F   <- 
DB    1,   1,   1,   5,   2,   2,   2,   3,   4,   2,   0,   0,   0,   5
.ENDLITERAL

;---------------------------------   FLASH ----------------------------------
playFLASH:
	;"SD   "
	;toLCD_String 0,0,"noCard          "
	call synth_init
	;        (,    FLASH     9)
	; (   )   ,     track_table (. )
	mov A,[altName+2]		;  
	and A,0x0F				;  ,    0...9
	asl A					;     x2 (..  - 2 )
	mov X,A
	index track_table+1
	mov [adr1+0],A			; .     
	mov A,X
	index track_table+0
	mov [adr1+1],A			; .     

	;   ,    0 
main_ReadData_loop:
	mov X,[adr1+0]	;  
	mov A,[adr1+1]	;  
	romx			;    A
	mov X,[ptrW]	;
	mov [X],A		;  
	
	;jz wait_finish	; 0 - ,   ,     ( 1)  (     )
	;jz playFLASH	; 0 - ,   ,    -     ( 2)

	inc [adr1+0]	;  1   FLASH
	adc [adr1+1],0

	;increment ptrW pointer 
	add [ptrW],1
	cmp [ptrW],buff+BUFFERSIZE*BUFFNUMBER
	jc .skip_init
		sub [ptrW],BUFFERSIZE*BUFFNUMBER
	.skip_init:

	cmp A,0
	jz wait_finish	; 0 - ,   ,     ( 1)  (      1)
	;jz playFLASH	; 0 - ,   ,    -     ( 2)

	;; check for free space between ptrW and ptrR
.wait_free_space:
	mov A,[ptrR]
	sub A,[ptrW]
	jnc .skip_corr
		add A,BUFFERSIZE*BUFFNUMBER
	.skip_corr:
	cmp A,1+1
	jc .wait_free_space
	jmp main_ReadData_loop

.LITERAL
track_table:;-------------------------      Big Endian  (   ) --------------------------
DW track0 ; -  
DW track1 ;Beatles - Girl
DW track2 ;  -   
DW track3 ;   (     0...5)
DW track4 ; 0,    (   A7-A6-A5-A4-A3-A2-A1-A0)
DW track5 ; 0,    -    C4    (7   )
DW track6 ; 0,       (" ") (    C2  B7  -  72 *0,5  = 36 )
DW track7 ; 6,       (" ") (    C2  B7  -  72 *0,5  = 36 )
DW track8 ;     -  (     0...5   )
DW track9 ;  1 / = 1   .    .
DW track0 
DW track0 
DW track0 
DW track0 
DW track0 
DW track0 
.ENDLITERAL

;----------------------------    -    -----------------------------
;n2:
	;toLCD_String 0,0,"noFile          "
	;    
	jmp wait_loop

;--------------------------------   ------------------------------------
wait_finish:
	;    (   [ptrW]==[ptrR])
	mov A,[ptrW]
	cmp A,[ptrR]
	jnz wait_finish

	;  
	call synth_notes_off

	;toLCD_String 1,0,"Loop"
	
	cmp [etap],1		;    FLASH ("  ")
	jz playFLASH		; ,    - 
	
		;     SD
	wait_loop:
		jmp wait_loop	;,     



;-----------------------------------      --------------------------------------------
LVD_ISR::
	;       
	;  ,   CPU   , ..    LVDThrottleBack  Disable
	push X					;(X    - !)
	call synth_notes_off	;   (X )
	call WaitLVD			;    -   VLT_CMP  (X ).     .
	;     -   ,   (     - 5 )
	pop X
	reti

;---------------------      (  VLT_CMP) --------------------------
WaitLVD:
	.waitReset:				;  .     .
			M8C_SetBank0
			mov[cntLVD+0],0				; 
			inc [cntLVD+1]				;    (   256 )
			jnc .noLED
				xor reg[PRT2DR],0x8		;  P2.3 (- ) -    256  ( 8,4    4 /) 		
			.noLED:
	.wait: 
			;mov X,150			; 150 * 9 + 4 = 1354 
			mov X,255			; 255 * 9 + 4 = 2299 
			.delay:				;
			dec X				;
			jnz .delay			;
			
			M8C_SetBank1
			tst reg[VLT_CMP],0x2
;jmp .waitReset				;     -       (42 + 1354   = 2149   CPU=3 ) 
			jnz .waitReset				;     -       (42 + 2299   = 5126   CPU=12 ) 
			;   
			inc [cntLVD+0]				;     
			jnc .wait					;      -   (.  "" 256   (30+2249)  = 0,05   12 ) 
	
	;      0,05 
    ;M8C_SetBank1
	;or reg[OSC_CR0],0x02	;  CPU 12 
 
    M8C_SetBank0			;
	and reg[PRT2DR],~0x8	;  P2.3 ( ) -  .   
	ret
;------------------------------   main.asm -------------------------------
